local P2xpos;
local P2ypos;
local P1,P2;
local spacing = 115
local arrows = {}
local beat = 0
local beat2 = 0
local allaySound
local songName= GAMESTATE:GetCurrentSong():GetSongDir() -- Looks for Song
local magicNum = math.random(0,10)
local left, right, up, down = 90, 270, 0, 180
local column1, column2, column3, column4, column5, column6, column7, column8

local function handler_mod_internal(str, pn) -- Aplies Players options to not be disabled-
	local ps= GAMESTATE:GetPlayerState(pn)
	local pmods= ps:GetPlayerOptionsString('ModsLevel_Song')
	ps:SetPlayerOptions('ModsLevel_Song', pmods .. ', ' .. str)
	--GAMESTATE:ApplyGameCommand('mod,'..str, pn)
end
local switch = {
	["U"] = function(self) self:GetParent():GetChild("SideArrow2-"):visible(false); self:rotationz(0) end,
	["R"] = function(self) self:GetParent():GetChild("SideArrow2-"):visible(false); self:rotationz(right) end,
	["D"] = function(self) self:GetParent():GetChild("SideArrow2-"):visible(false);  self:rotationz(180) end,
	["L"] = function(self) self:GetParent():GetChild("SideArrow2-"):visible(false); self:rotationz(left) end,
	--jumps
	["7"] = function(self) 
		-- up left
		self:rotationz(left); 
		self:GetParent():GetChild("SideArrow2-"):visible(true):rotationz(0) 
	end,
	["9"] = function(self)
		-- up right 
		self:rotationz(0) 
		self:GetParent():GetChild("SideArrow2-"):visible(true):rotationz(right) 

	end,
	["1"] = function(self) 
		-- down left
		self:rotationz(left)
		self:GetParent():GetChild("SideArrow2-"):visible(true):rotationz(180) 
	end,
	["3"] = function(self) 
		-- down right
		self:rotationz(180)
		self:GetParent():GetChild("SideArrow2-"):visible(true):rotationz(right)

	 end,
	["5"] = function(self) 
		-- left right
		self:rotationz(left)
		self:GetParent():GetChild("SideArrow2-"):visible(true):rotationz(right) 
	end,
	["2"] = function(self)
		-- up down
		self:rotationz(0)
		self:GetParent():GetChild("SideArrow2-"):visible(true):rotationz(180)
	end,
  }

local switch2 = {
	["R"] = function(self)  self:setstate(0) end,
	["B"] = function(self) self:setstate(2) end,
	["G"] = function(self) self:setstate(1) end
  }
local function handler_mod(str) -- Looks for many players are on the screen
	for i=1,2 do
		handler_mod_internal(str, 'PlayerNumber_P' .. i)
	end
end


local IsEditMode = function()
	local topscreen = SCREENMAN:GetTopScreen()
	if not topscreen then
	  lua.ReportScriptError("IsEditMode() check failed to run because there is no Screen yet.")
	  return nil
	end
  
	return (THEME:GetMetric(topscreen:GetName(), "Class") == "ScreenEdit")
  end
  
  -- helper function for returning the player AF
  -- works as expected in ScreenGameplay
  -- uses IsEditMode() to find the player AF if we're in EditMode
  --     arguments:  pn is a number like 1 or 2
  --     returns:    the "PlayerP1" or "PlayerP2" ActorFrame in ScreenGameplay
  --                 or, the unnamed equivalent in ScrenEdit
  local GetPlayerAF = function(pn)
	local topscreen = SCREENMAN:GetTopScreen()
	if not topscreen then
	  lua.ReportScriptError("GetPlayerAF() failed to find the player ActorFrame because there is no Screen yet.")
	  return nil
	end
  
	local playerAF = nil
  
	-- Get the player ActorFrame on ScreenGameplay
	-- It's a direct child of the screen and named "PlayerP1" for P1
	-- and "PlayerP2" for P2.
	-- This naming convention is hardcoded in the SM5 engine.
	--
	-- ScreenEdit does not name its player ActorFrame, but we can still find it.
  
	-- find the player ActorFrame in edit mode
	if IsEditMode() then
	  -- loop through all nameless children of topscreen
	  -- and find the one that contains the NoteField
	  -- which is thankfully still named "NoteField"
	  for _,nameless_child in ipairs(topscreen:GetChild("")) do
		if nameless_child:GetChild("NoteField") then
		  playerAF = nameless_child
		  break
		end
	  end
  
	-- find the player ActorFrame in gameplay
	else
	  local player_af = topscreen:GetChild("PlayerP"..pn)
	  if player_af then
		playerAF = player_af
	  end
	end
  
	return playerAF
  end

local function simple_rot_spline_demo(notefield, pn)
    -- This assumes dance game mode.  There are 8 entries in column_rots to
    -- make it work in double mode.  The rotations are picked to make all
    -- arrows point down.
    -- Fetching a notefield can be done on gameplay with this:
    -- SCREENMAN:GetTopScreen():GetChild("Player"..ToEnumShortString(pn))
    --   :GetChild("NoteField")
    -- Edit mode names its actors differently, so that doesn't work in edit
    -- mode.  In edit mode, the player actor is simply named "Player".
    -- Docs/Luadoc/Lua.xml has more info on splines.
    local column_rots= {4*math.pi, math.pi, 0, 2*math.pi, math.pi, math.pi, math.pi, math.pi,}
    
    for i, column in ipairs(notefield:get_column_actors()) do
        
      local rot_handler= column:get_rot_handler()
      -- NoteColumnSplineMode_Position makes the column ignore mods like dizzy,
      -- twirl, and roll, because those also change the note's rotation.
      -- NoteColumnSplineMode_Offset would make it sum the effect of mods and
      -- the spline.
		rot_handler:set_spline_mode("NoteColumnSplineMode_Position")
		local spline= rot_handler:get_spline()

		-- Get each individual arrow for each player and assign it the respective column from
		-- left to right
		-- P1L = 1 to P2R = 8
		if i == 1 and pn == 1 then 
			column1 = column
		end
		if i == 2 and pn == 1 then
			column2 = column
		end
		if i == 3 and pn == 1 then
			column3 = column
		end
		if i == 4 and pn == 1 then
			column4 = column
		end
		if i == 1 and pn == 2 then 
			column5 = column
		end
		if i == 2 and pn == 2 then
			column6 = column
		end
		if i == 3 and pn == 2 then
			column7 = column
		end
		if i == 4 and pn == 2 then
			column8 = column
		end
      -- Since the notes don't need to change rotation over time, the spline
      -- has only one point.  That one point sets the x and y rotation to 0,
      -- and fetches the z rotation from the column_rots table.
   --   spline:set_loop(true):set_size(1):set_point(1, {0, 0, column_rots[i]})
      -- If the spline had more than one point, it would need to be solved to
      -- make the notes smoothly turn.
      -- spline:solve()
    end
  end
local function handler_init() -- Useful for command shorcuts
	fgcurcommand = 0;
	wndr_skewx=0.3;
	checked = false;
	
	--lua course :D	/ timed mod management	
	curmod = 1;
	--{beat,'mod'},
	mods = {
		
	}

	--SCREAMING GUMBALL / timed message broadcaster
	curmessage = 1;
	--{beat,message,ignoreIfAhead}
	messages = {
	--intro
		{7, 'Begin'},

		{23, 'FlyBy'},
		{60, "PickUpItems"},
		{65, "Chortles"},
		{68, 'SpaceInvaders', "DUDUDR5"},
		{76, 'SpaceInvaders2', "LRLRLU2"},
        {84, 'SpaceInvaders', "LUDRLR5"},
		{89, 'SpaceInvaders2', "12952539", "RRRRRRR", 2.5},

		{93, 'ReturnItems'},

		{188, "PickUpItems"},
		{193, "Chortles"},
		{196, 'SpaceInvaders', "LDRDLU2"},
		{204, 'SpaceInvaders2', "RDLDRL5"},
        {212, 'SpaceInvaders', "RUDLRL3"},
		{217, 'SpaceInvaders2', "7395252", "RRRRRRR", 2.5},
		{221, 'ReturnItems'},

		{317, "PickUpItems"},
		{322, "Chortles"},
		{324, 'SpaceInvaders',  "LDRDLR3"},
		{332, 'SpaceInvaders2', "RDLDRL7"},
        {340, 'SpaceInvaders',  "LDURLR5"},
		{345, 'SpaceInvaders2', "971325LDU", "RRRRRRR", 2.5},
		{349, 'ReturnItems'}

	}

	for pn=1,2 do
		local a = GetPlayerAF(pn)
		if a then
			notefield = a:GetChild("NoteField")

			-- and pass that player's notefield into the rotation function defined above
			simple_rot_spline_demo(notefield, pn)
		end

	end
end

local function handler_update() -- Updates the command to look for the players at the start of the song.

	if GAMESTATE:GetSongBeat()>=0.1 and not checked then
	
	if GetPlayerAF(1) then
		P1 = GetPlayerAF(1)
	end
    if P1 then
        P1xpos=P1:GetX();
        P1ypos=P1:GetY();
    end
	if GetPlayerAF(2) then
		P2 = GetPlayerAF(2)
	end
    if P2 then
        P2xpos=P2:GetX();
        P2ypos=P2:GetY();
    end
    --PE = SCREENMAN:GetTopScreen():GetChild('')

    screen = SCREENMAN:GetTopScreen()

    checked = true;

	end

	if GAMESTATE:GetSongBeat() > beat2 + 18 then
		beat2 = GAMESTATE:GetSongBeat()
		if ((beat > 14 and beat < 20) or (beat > 44 and beat < 108)  or (beat > 168 and beat < 190)) then
		else
			magicNum = math.random(1,100)
			MESSAGEMAN:Broadcast("FlyBy1")
		end
	end
	beat = GAMESTATE:GetSongBeat()

	-- Collect all the mods that will be applied in this frame into one string.
	-- Mod tweening doesn't work correctly if the mods are in seperate commands.
	local mods_this_frame= {}
	local function add_mod(mod_str)
		mods_this_frame[#mods_this_frame+1]= mod_str
	end
	local function execute_mods()
		if #mods_this_frame <= 0 then return end
		local total_mod_str= ""
		for i, ms in ipairs(mods_this_frame) do
			if #total_mod_str > 0 then
				total_mod_str= total_mod_str .. ", "
			end
			total_mod_str= total_mod_str .. ms
		end
		handler_mod(total_mod_str)
	end
	
	while curmod<= #mods and GAMESTATE:GetSongBeat()>=mods[curmod][1] do
		add_mod(mods[curmod][2])
		curmod = curmod+1
	end

	execute_mods()
	while curmessage<= #messages and GAMESTATE:GetSongBeat()>=messages[curmessage][1] do
		if messages[curmessage][5] then
			MESSAGEMAN:Broadcast(messages[curmessage][2], {Positions=messages[curmessage][3], Type=messages[curmessage][4], Sleep=messages[curmessage][5]})
			curmessage = curmessage+1;
		elseif messages[curmessage][4] then
			MESSAGEMAN:Broadcast(messages[curmessage][2], {Positions=messages[curmessage][3], Type=messages[curmessage][4]})
			curmessage = curmessage+1;
		elseif messages[curmessage][3] then
            MESSAGEMAN:Broadcast(messages[curmessage][2], {Positions=messages[curmessage][3], Type="RBRBRRR"})
			curmessage = curmessage+1;
		else
			MESSAGEMAN:Broadcast(messages[curmessage][2])
			curmessage = curmessage+1;
		end
	end
end
local af = Def.ActorFrame {

	OnCommand= function(self)
        handler_init()
        self:SetUpdateFunction(handler_update)
    end,
	Def.Quad{
		Name= "I may be sleeping, but I preserve the world.",
		InitCommand= cmd(visible,false),
		OnCommand= cmd(sleep,1000),
	},
	Def.Quad{
		OnCommand= cmd(diffuse,0,0,0,1;diffusealpha,0;zoomto,6,SCREEN_HEIGHT;x,SCREEN_CENTER_X;y,SCREEN_CENTER_Y),
		PickUpItemsMessageCommand = function(self)
			if not IsEditMode() then

				if P1 then
					column1:sleep(4):decelerate(2):addx(5*SCREEN_WIDTH/4)
					column2:sleep(4):decelerate(2):addx(5*SCREEN_WIDTH/4)--:addy(0.75*SCREEN_HEIGHT/4)
					column3:sleep(4):decelerate(2):addx(5*SCREEN_WIDTH/4)--:addy(1.5*SCREEN_HEIGHT/4) 
					column4:sleep(4):decelerate(2):addx(5*SCREEN_WIDTH/4)--:addy(2*SCREEN_HEIGHT/4) 
				end
				if P2 then
					column8:sleep(4):decelerate(2):addx(-5*SCREEN_WIDTH/4)
					column7:sleep(4):decelerate(2):addx(-5*SCREEN_WIDTH/4)--:addy(0.75*SCREEN_HEIGHT/4)
					column6:sleep(4):decelerate(2):addx(-5*SCREEN_WIDTH/4)--:addy(1.5*SCREEN_HEIGHT/4) 
					column5:sleep(4):decelerate(2):addx(-5*SCREEN_WIDTH/4)--:addy(2*SCREEN_HEIGHT/4) 
				end
			end
		end,
		ReturnItemsMessageCommand = function(self)
			if not IsEditMode() then
				if P1 then
					column1:decelerate(4):addx(-5*SCREEN_WIDTH/4)
					column2:decelerate(4):addx(-5*SCREEN_WIDTH/4)--:addy(-0.75*SCREEN_HEIGHT/4)
					column3:decelerate(4):addx(-5*SCREEN_WIDTH/4)--:addy(-1.5*SCREEN_HEIGHT/4) 
					column4:decelerate(4):addx(-5*SCREEN_WIDTH/4)--:addy(-2*SCREEN_HEIGHT/4) 
				end
				if P2 then
					column8:decelerate(4):addx(5*SCREEN_WIDTH/4)
					column7:decelerate(4):addx(5*SCREEN_WIDTH/4)--:addy(-0.75*SCREEN_HEIGHT/4)
					column6:decelerate(4):addx(5*SCREEN_WIDTH/4)--:addy(-1.5*SCREEN_HEIGHT/4) 
					column5:decelerate(4):addx(5*SCREEN_WIDTH/4)--:addy(-2*SCREEN_HEIGHT/4) 
				end
			end
		
		end
    },
	Def.Sound{
		File="allay_chortles1.ogg",
		InitCommand=function(self)
			self:get():volume(0.5)
		end,
		ChortlesMessageCommand=function(self)
			if (magicNum % 3 == 2) then
				self:stop():sleep(3):play()
			end
		end
	},
	Def.Sound{
		File="allay_chortles2.ogg",
		InitCommand=function(self)
			self:get():volume(0.5)
		end,
		ChortlesMessageCommand=function(self)
			if (magicNum % 3 == 1) then
				self:stop():sleep(3):play()
			end
		end
	},
	Def.Sound{
		File="allay_chortles3.ogg",
		InitCommand=function(self)
			self:get():volume(0.5)
		end,
		ChortlesMessageCommand=function(self)
			if (magicNum % 3 == 0) then
				self:stop():sleep(3):play()
			end
		end
	},
	Def.Sound{
		File="allay_seeks1.ogg",
		InitCommand=function(self)
			self:get():volume(0.5)
		end,
		PickUpItemsMessageCommand=function(self)
			if magicNum % 2 == 0 then
				self:stop():play()
			end
		end
	},
	Def.Sound{
		File="allay_seeks2.ogg",
		InitCommand=function(self)
			self:get():volume(0.5)
		end,
		PickUpItemsMessageCommand=function(self)
			if (magicNum % 2 == 1) then
				self:stop():play()
			end
		end
	},
	Def.Sound{
		File="AllayYearns.ogg",
		FlyByMessageCommand=function(self)
			self:stop():sleep(1.5):play()
		end
	}

}
-- For loop that creates 5 allays for going across the screen
-- -95 -40 +30 +80
local arrowPos = { 
	{-95,-40,30,80, 80},
	{ 115, 40, -30, -80, -80},
}

for i=1,5 do
    local arrow
    af[#af+1] = Def.ActorFrame {
		InitCommand=function(self)
			self:visible(true):x(SCREEN_WIDTH+(i*spacing)):y(75):zoom(0.88)
			self:bob():effectmagnitude(1,3,1):rotationy(180)
		end,
		FlyBy1MessageCommand=function(self)
			if magicNum % i == 0 then
				local speed = math.random(4,10)
				if math.random(1,20) % 4 == 0 or speed > 6 then
					self:animate(true)
				else
					self:animate(false):setstate(0):bob():effectmagnitude(1,8,1)
				end
				self:sleep(math.random(0,5)):rotationy(180):y(math.random(0,SCREEN_HEIGHT)):x(8*SCREEN_WIDTH/4-(i*spacing)):decelerate(speed):x(-4*SCREEN_WIDTH/4+(i*spacing)):y(math.random(3*SCREEN_HEIGHT/20,18*SCREEN_HEIGHT/20))
				MESSAGEMAN:Broadcast("Chortles")
			end
		end,
		Def.Sprite{
			Name = 'Allay'..i,
			Texture = 'allay 8x7.png';
			Frames=Sprite.LinearFrames(51, 4),
			InitCommand = function(self) 
			  allay10 = self; 
			  self:zoom(0.7):rotationy(180)
			  self:wag():effectmagnitude(-4,5,-1):animate(false):visible(true)
			end; 
		},
        Def.Sprite {
        Texture = 'dance 3x1.png';
        Name = "Arrow"..i,
        InitCommand = function(self) 
            arrow = self
            self:visible(false):zoom(0.23):setstate(i % 2 == 1 and 0 or 2):animate(false):x(30):y(25)
            self:wag():effectmagnitude(1,10,1)
        end;
        }
    }
    arrows[i] = arrow
end

for i=1,5 do
    local arrow
    af[#af+1] = Def.ActorFrame {
		InitCommand=function(self)
			self:visible(true):x(0-(i*spacing)):y(SCREEN_HEIGHT-75):zoom(1)
			self:bob():effectmagnitude(1,3,1):rotationy(0)
		end,
		FlyBy1MessageCommand=function(self)
			if magicNum % i == 0 then
				local speed = math.random(4,9)
				if math.random(1,20) % 4 == 0 or speed > 6 then
					self:animate(true)
				else
					self:animate(false):setstate(0):bob():effectmagnitude(1,8,1)
				end
				self:sleep(math.random(0,5)):rotationy(0):y(math.random(3*SCREEN_HEIGHT/20,SCREEN_HEIGHT)):x(-4*SCREEN_WIDTH/4+(i*spacing)):accelerate(speed):x(8*SCREEN_WIDTH/4-(i*spacing)):y(math.random(3*SCREEN_HEIGHT/20,18*SCREEN_HEIGHT/20))
				MESSAGEMAN:Broadcast("Chortles")
			end
		end,
		Def.Sprite{
			Name = 'Allay'..i,
			Texture = 'allay 8x7.png';
			Frames=Sprite.LinearFrames(51, 4),
			InitCommand = function(self) 
			  allay10 = self; 
			  self:zoom(0.7):rotationy(180)
			  self:wag():effectmagnitude(-1,6,-1):animate(false):visible(true)
			end; 
			FlyByMessageCommand=function(self)
				self:animate(true)
			end,
		},
        Def.Sprite {
        Texture = 'dance 3x1.png';
        Name = "Arrow"..i,
        InitCommand = function(self) 
            arrow = self
            self:visible(false):zoom(0.23):setstate(i % 2 == 1 and 0 or 2):animate(false):x(30):y(25)
            self:wag():effectmagnitude(1,10,1)
        end;
		}
    }
    arrows[i] = arrow
end

for i=1,5 do
    local arrow
    af[#af+1] = Def.ActorFrame {
		InitCommand=function(self)
			self:visible(true):x(SCREEN_WIDTH+(i*spacing)):y(75):zoom(1)
			self:bob():effectmagnitude(1,3,1):rotationy(180)
		end,
		PickUpItemsMessageCommand = function(self)
			self:x(5*SCREEN_WIDTH/4):animate(false):setstate(0)
			self:rotationy(180)
			self:decelerate(4):x(P1xpos+arrowPos[1][i]):y(P1ypos/3)
			self:linear(0):rotationy(0) 
			self:decelerate(2):addx(5*SCREEN_WIDTH/4)
			self:linear(0):rotationy(180) 
			 --xy(4*SCREEN_WIDTH/5,1*SCREEN_HEIGHT/4)
		end,
		ReturnItemsMessageCommand = function(self)
			self:rotationy(180):x(5*SCREEN_WIDTH/4+(i*spacing)):animate(false):setstate(0)
			--self:addx(-5*SCREEN_WIDTH/4):addy(-400)
			self:decelerate(4):x(P1xpos+arrowPos[1][i]):y(P1ypos/3)
			self:linear(0):rotationy(0) 
			self:linear(2):addx(5*SCREEN_WIDTH/4)
			self:linear(0):rotationy(180) 
			 --xy(4*SCREEN_WIDTH/5,1*SCREEN_HEIGHT/4)
		end,
		FlyByMessageCommand=function(self)
			self:queuecommand('Loop');			
			self:linear(3):x(-4*SCREEN_WIDTH/4+(i*spacing))
		end,
		LoopCommand=function(self)
			if beat > 25 and beat < 40 then
				self:y(2*math.sin(i*beat*math.pi*0.5))
			end
			self:sleep(0.166666);
			self:queuecommand('Loop');			
		end,
		-- SpaceInvadersMessageCommand = function(self, params)
		-- 	self:x(SCREEN_WIDTH+(i*spacing)):accelerate(2.85):x(-4*SCREEN_WIDTH/4+(i*spacing))
		-- end,
		Def.Sprite{
			Name = 'Allay'..i,
			Texture = 'allay 8x7.png';
			Frames=Sprite.LinearFrames(51, 4),
			InitCommand = function(self) 
			  allay10 = self; 
			  self:zoom(0.7):rotationy(180)
			  self:wag():effectmagnitude(-4,5,-1):animate(false):visible(true)
			end; 
			FlyByMessageCommand=function(self)
				self:animate(true)
			end,
			ActiveCommand=function(self)
				self:linear(0.2):zoom(0.8):addy(15):addrotationy(360)
				self:linear(0.3):zoom(0.7)
			end,
			PickUpItemsMessageCommand = function(self)
				self:animate(false):setstate(0)
			end,
			ReturnItemsMessageCommand = function(self)
				self:animate(false):setstate(0)
			end
		},
        Def.Sprite {
        Texture = 'dance 3x1.png';
        Name = "Arrow"..i,
        InitCommand = function(self) 
            arrow = self
            self:visible(false):zoom(0.23):setstate(i % 2 == 1 and 0 or 2):animate(false):x(30):y(25)
            self:wag():effectmagnitude(1,10,1)
        end;
        }
    }
    arrows[i] = arrow
end

for i=1,5 do
    local arrow
    af[#af+1] = Def.ActorFrame {
		InitCommand=function(self)
			self:visible(true):x(0-(i*spacing)):y(SCREEN_HEIGHT-75):zoom(1)
			self:bob():effectmagnitude(1,3,1):rotationy(0)
		end,
		PickUpItemsMessageCommand = function(self)
			self:visible(true)
		end,
		FlyByMessageCommand=function(self)
			self:queuecommand('Loop');			
			self:linear(3):x(8*SCREEN_WIDTH/4-(i*spacing))
		end,
		LoopCommand=function(self)
			if beat > 25 and beat < 40 then
				self:y(2*math.sin(i*beat*math.pi*0.5))
			end
			self:sleep(0.166666);
			self:queuecommand('Loop');			
		end,
		PickUpItemsMessageCommand = function(self)
			self:x(-5*SCREEN_WIDTH/4):animate(false):setstate(0)
			self:rotationy(0)
			self:decelerate(4):x(P2xpos+arrowPos[2][i]):y(P2ypos/3)
			self:linear(0):rotationy(180) 
			self:decelerate(2):addx(-5*SCREEN_WIDTH/4)
			self:linear(0):rotationy(0) 
		end,
		ReturnItemsMessageCommand = function(self)
			self:x(-1*SCREEN_WIDTH/4-(i*spacing)):animate(false):setstate(0):rotationy(0) 
			self:decelerate(4):x(P2xpos+arrowPos[2][i]):y(P2ypos/3)
			self:linear(0):rotationy(180) 
			self:decelerate(2):addx(-5*SCREEN_WIDTH/4)
			self:linear(0):rotationy(0) 
		end,
		-- SpaceInvadersMessageCommand = function(self, params)
		-- 	self:x(SCREEN_WIDTH+(i*spacing)):accelerate(2.85):x(-4*SCREEN_WIDTH/4+(i*spacing))
		-- end,
		Def.Sprite{
			Name = 'Allay'..i,
			Texture = 'allay 8x7.png';
			Frames=Sprite.LinearFrames(51, 4),
			InitCommand = function(self) 
			  allay10 = self; 
			  self:zoom(0.7):rotationy(180)
			  self:wag():effectmagnitude(-1,6,-1):animate(false):visible(true)
			end; 
			FlyByMessageCommand=function(self)
				self:animate(true)
			end,
			ActiveCommand=function(self)
				self:linear(0.2):zoom(0.8):addy(15):addrotationy(360)
				self:linear(0.3):zoom(0.7)
			end,
			PickUpItemsMessageCommand = function(self)
				self:animate(false):setstate(0)
			end,
			ReturnItemsMessageCommand = function(self)
				self:animate(false):setstate(0)
			end
		},
        Def.Sprite {
        Texture = 'dance 3x1.png';
        Name = "Arrow"..i,
        InitCommand = function(self) 
            arrow = self
            self:visible(false):zoom(0.23):setstate(i % 2 == 1 and 0 or 2):animate(false):x(30):y(25)
            self:wag():effectmagnitude(1,10,1)
        end;
        -- SpaceInvadersMessageCommand = function(self, params)
		-- 	self:visible(true)
        --     if params.Positions then
        --         -- colorN = string.sub(notes[currNote][2], 1, 1)
		-- 		local dir = string.sub(params.Positions, i, i)
        --         switch[dir](self)
        -- --     end
        -- end
        }
    }
    arrows[i] = arrow
end
af[#af+1] = Def.ActorProxy {
	BeginMessageCommand = function(self)
		if P1 then
			self:SetTarget(P1)
		end
	end
}

af[#af+1] = Def.ActorProxy {
	BeginMessageCommand = function(self)
		if P2 then
			self:SetTarget(P2)
		end
	end
}
-- Left Allays
for i=1,7 do
    local arrow
    af[#af+1] = Def.ActorFrame {
		InitCommand=function(self)
			if i == 7 then
				self:visible(true):x(0-((i+2)*spacing)):y(-60+((i-1)*spacing*0.7))

			else
				self:visible(true):x(0-(i*spacing)):y(-60+(i*spacing*0.7)):zoom(1)
			end
			if i == 7 or i == 6 then
				self:zoom(0.75)
			end
			self:bob():effectmagnitude(1,10,1):rotationy(0)
		end,
		PickUpItemsMessageCommand = function(self)
			self:visible(true)
		end,
		FlyByMessageCommand=function(self)
			--self:linear(3):x(-4*SCREEN_WIDTH/4+(i*spacing))
		end,
		SpaceInvadersMessageCommand = function(self, params)
			if i == 7 then
				self:linear(0.1):rotationy(0):decelerate(1.5):x(0+(3.5*spacing)-((i+2)*SCREEN_WIDTH/28)):y(-60+((i-1)*spacing*0.7))
			else
				self:linear(0.1):rotationy(0):decelerate(1.5):x(0+(3.5*spacing)-(i*SCREEN_WIDTH/28)):y(-60+(i*spacing*0.7))
			end

			if params.Sleep then
				self:sleep(0.103044*(i)*params.Sleep-0.103044):linear(0.1):rotationy(180)
			else
				if i == 6 then
					self:sleep(0.103044*(i+3)):linear(0.1):rotationy(180)
				elseif i == 7 then
					self:sleep(0.103044*(i+5)):linear(0.1):rotationy(180)
				
				else
					self:sleep(0.103044*i):linear(0.1):rotationy(180)
				end
			end
			self:accelerate(1.35-0.5):x(0-(i*spacing))
		end,
		Def.Sprite{
			Name = 'SideAllay'..i,
			Texture = 'allay 8x7.png';
			Frames=Sprite.LinearFrames(51, 4),
			InitCommand = function(self) 
			  --allay10 = self; 
			  self:zoom(0.7):rotationy(180)
			  self:wag():effectmagnitude(-1,5,-1):animate(false):visible(true)
			end; 
			ActiveCommand=function(self)
				self:linear(0.2):zoom(0.8):addy(15):addrotationy(360)
				self:linear(0.3):zoom(0.7)
			end,
		},
        Def.Sprite {
        Texture = 'dance 3x1.png';
        Name = "SideArrow1-"..i,
        InitCommand = function(self) 
           -- arrow = self
            self:visible(true):zoom(0.23):setstate(i == 6 and 0 or i % 2 == 1 and 0 or 2):animate(false):x(30):y(25)
            self:wag():effectmagnitude(1,10,1)
        end;
        SpaceInvadersMessageCommand = function(self, params)
			if params then
				if params.Positions then
					-- colorN = string.sub(notes[currNote][2], 1, 1)
					local dir = string.sub(params.Positions, i, i)
					switch[dir](self)
				end
				if params.Type then
					local noteType= string.sub(params.Type, i, i)
					switch2[noteType](self)
				end
			end
        end
        },
		Def.Sprite {
			Texture = 'dance 3x1.png';
			Name = "SideArrow2-",
			InitCommand = function(self) 
				--arrow = self
				self:visible(false):zoom(0.23):setstate(i == 6 and 0 or i % 2 == 1 and 0 or 2):animate(false):x(-16):y(25)
				self:wag():effectmagnitude(1,10,1)
			end;
			SpaceInvadersMessageCommand = function(self, params)
				if params then

					if params.Positions then
						-- colorN = string.sub(notes[currNote][2], 1, 1)
						local dir = string.sub(params.Positions, i, i)
						switch[dir](self)
					end
					if params.Type then
						local noteType= string.sub(params.Type, i, i)
						switch2[noteType](self)
					end
				end
			end
			}
    }
    arrows[i] = arrow
end
for i=8,14 do
    local arrow
    af[#af+1] = Def.ActorFrame {
		InitCommand=function(self)
			if i == 14 then
				self:visible(true):x(0-((i-4)*spacing)):y(-60+((i-8)*spacing*0.7)):zoom(0.75)
			else
				self:visible(true):x(0-((i-7)*spacing)):y(-60+((i-7)*spacing*0.7)):zoom(1)
			end
			if i == 13 or i == 14 then
				self:zoom(0.75)
			end
			self:bob():effectmagnitude(1,10,1):rotationy(180)

		end,
		PickUpItemsMessageCommand = function(self)
			self:visible(true)
		end,
		FlyByMessageCommand=function(self)
			--self:linear(3):x(-4*SCREEN_WIDTH/4+((i-7)*spacing))
		end,
		SpaceInvaders2MessageCommand = function(self, params)
			if i == 14 then
				self:linear(0.1):rotationy(0):decelerate(1.5):x(0+(3.5*spacing)-((i-4)*SCREEN_WIDTH/28)):y(-60+((i-8)*spacing*0.7))
			else
				self:linear(0.1):rotationy(0):decelerate(1.5):x(0+(3.5*spacing)-((i-7)*SCREEN_WIDTH/28)):y(-60+((i-7)*spacing*0.7))
			end

			if params.Sleep then
				self:sleep(0.103044*(i-7)*params.Sleep-0.103044):linear(0.1):rotationy(180)
			else
				if i == 13 then
					self:sleep(0.103044*(i-4)):linear(0.1):rotationy(180)
				elseif i == 14 then
					self:sleep(0.103044*(i-2)):linear(0.1):rotationy(180)
				else
					self:sleep(0.103044*(i-7)):linear(0.1):rotationy(180)
				end
			end

			self:accelerate(1.35-0.5):x(0-((i-7)*spacing))
		end,
		Def.Sprite{
			Name = 'SideAllay'..i,
			Texture = 'allay 8x7.png';
			Frames=Sprite.LinearFrames(51, 4),
			InitCommand = function(self) 
			  --allay10 = self; 
			  self:zoom(0.7):rotationy(180)
			  self:wag():effectmagnitude(-1,5,-1):animate(false):visible(true)
			end; 
		},
        Def.Sprite {
        Texture = 'dance 3x1.png';
        Name = "SideArrow1-"..i,
        InitCommand = function(self) 
           -- arrow = self
            self:visible(true):zoom(0.23):setstate(i == 13 and 0 or (i-7) % 2 == 1 and 0 or 2):animate(false):x(30):y(25)
            self:wag():effectmagnitude(1,10,1)
        end;
        SpaceInvaders2MessageCommand = function(self, params)
			if params then
				if params.Positions then
					-- colorN = string.sub(notes[currNote][2], 1, 1)
					local dir = string.sub(params.Positions, (i-7), (i-7))
					switch[dir](self)
				end
				if params.Type then
					local noteType= string.sub(params.Type, (i-7), (i-7))
					switch2[noteType](self)
				end
			end
        end
        },
		Def.Sprite {
			Texture = 'dance 3x1.png';
			Name = "SideArrow2-",
			InitCommand = function(self) 
				--arrow = self
				self:visible(false):zoom(0.23):setstate(i == 13 and 0 or (i-7) % 2 == 1 and 0 or 2):animate(false):x(-16):y(25)
				self:wag():effectmagnitude(1,10,1)
			end;
			SpaceInvaders2MessageCommand = function(self, params)
				if params then
					if params.Positions then
						-- colorN = string.sub(notes[currNote][2], 1, 1)
						local dir = string.sub(params.Positions, (i-7), (i-7))
						switch[dir](self)
					end
					if params.Type then
						local noteType= string.sub(params.Type, (i-7), (i-7))
						switch2[noteType](self)
					end
				end
			end
			}
    }
end


for i=1,7 do
    local arrow
    af[#af+1] = Def.ActorFrame {
		InitCommand=function(self)
			if i == 7 then
				self:visible(true):x(SCREEN_WIDTH+((i+2)*spacing)):y(-60+((i-1)*spacing*0.7))

			else
				self:visible(true):x(SCREEN_WIDTH+(i*spacing)):y(-60+(i*spacing*0.7)):zoom(1)
			end
			if i == 7 or i == 6 then
				self:zoom(0.75)
			end
			self:bob():effectmagnitude(1,10,1):rotationy(180)
		end,
		PickUpItemsMessageCommand = function(self)
			self:visible(true)
		end,
		FlyByMessageCommand=function(self)
			--self:linear(3):x(-4*SCREEN_WIDTH/4+(i*spacing))
		end,
		SpaceInvadersMessageCommand = function(self, params)
			if i == 7 then
				self:linear(0.1):rotationy(180):decelerate(1.5):x(SCREEN_WIDTH-(3.5*spacing)+((i+2)*SCREEN_WIDTH/28)):y(-60+((i-1)*spacing*0.7))
			else
				self:linear(0.1):rotationy(180):decelerate(1.5):x(SCREEN_WIDTH-(3.5*spacing)+(i*SCREEN_WIDTH/28)):y(-60+(i*spacing*0.7))
			end

			if params.Sleep then
				self:sleep(0.103044*(i)*params.Sleep-0.103044):linear(0.1):rotationy(0)
			else
				if i == 6 then
					self:sleep(0.103044*(i+3)):linear(0.1):rotationy(0)
				elseif i == 7 then
					self:sleep(0.103044*(i+5)):linear(0.1):rotationy(0)
				
				else
					self:sleep(0.103044*i):linear(0.1):rotationy(0)
				end
			end
			self:accelerate(1.35-0.5):x(SCREEN_WIDTH+(i*spacing))
		end,
		Def.Sprite{
			Name = 'SideAllay'..i,
			Texture = 'allay 8x7.png';
			Frames=Sprite.LinearFrames(51, 4),
			InitCommand = function(self) 
			  --allay10 = self; 
			  self:zoom(0.7):rotationy(180)
			  self:wag():effectmagnitude(-1,5,-1):animate(false):visible(true)
			end; 
			ActiveCommand=function(self)
				self:linear(0.2):zoom(0.8):addy(15):addrotationy(360)
				self:linear(0.3):zoom(0.7)
			end,
			PickUpItems2MessageCommand = function(self)
				self:addrotationy(180)
				self:decelerate(4):x(P1xpos+50):y(P1ypos/3)
				self:linear(0):addrotationy(180) 
				self:linear(3.25):addx(2.05*SCREEN_WIDTH/4):addy(1.5*SCREEN_HEIGHT/4) 
				self:linear(0):addrotationy(180) 
			end
		},
        Def.Sprite {
        Texture = 'dance 3x1.png';
        Name = "SideArrow1-"..i,
        InitCommand = function(self) 
           -- arrow = self
            self:visible(true):zoom(0.23):setstate(i == 6 and 0 or i % 2 == 1 and 0 or 2):animate(false):x(30):y(25)
            self:wag():effectmagnitude(1,10,1)
        end;
        SpaceInvadersMessageCommand = function(self, params)
			if params then
				if params.Positions then
					-- colorN = string.sub(notes[currNote][2], 1, 1)
					local dir = string.sub(params.Positions, i, i)
					switch[dir](self)
				end
				if params.Type then
					local noteType= string.sub(params.Type, i, i)
					switch2[noteType](self)
				end
			end
        end
        },
		Def.Sprite {
			Texture = 'dance 3x1.png';
			Name = "SideArrow2-",
			InitCommand = function(self) 
				--arrow = self
				self:visible(false):zoom(0.23):setstate(i == 6 and 0 or i % 2 == 1 and 0 or 2):animate(false):x(-16):y(25)
				self:wag():effectmagnitude(1,10,1)
			end;
			SpaceInvadersMessageCommand = function(self, params)
				if params then

					if params.Positions then
						-- colorN = string.sub(notes[currNote][2], 1, 1)
						local dir = string.sub(params.Positions, i, i)
						switch[dir](self)
					end
					if params.Type then
						local noteType= string.sub(params.Type, i, i)
						switch2[noteType](self)
					end
				end
			end
			}
    }
    arrows[i] = arrow
end
for i=8,14 do
    local arrow
    af[#af+1] = Def.ActorFrame {
		InitCommand=function(self)
			if i == 14 then
				self:visible(true):x(SCREEN_WIDTH+((i-4)*spacing)):y(-60+((i-8)*spacing*0.7)):zoom(0.75)
			else
				self:visible(true):x(SCREEN_WIDTH+((i-7)*spacing)):y(-60+((i-7)*spacing*0.7)):zoom(1)
			end
			if i == 13 or i == 14 then
				self:zoom(0.75)
			end
			self:bob():effectmagnitude(1,10,1):rotationy(180)

		end,
		PickUpItemsMessageCommand = function(self)
			self:visible(true)
		end,
		FlyByMessageCommand=function(self)
			--self:linear(3):x(-4*SCREEN_WIDTH/4+((i-7)*spacing))
		end,
		SpaceInvaders2MessageCommand = function(self, params)
			if i == 14 then
				self:linear(0.1):rotationy(180):decelerate(1.5):x(SCREEN_WIDTH-(3.5*spacing)+((i-4)*SCREEN_WIDTH/28)):y(-60+((i-8)*spacing*0.7))
			else
				self:linear(0.1):rotationy(180):decelerate(1.5):x(SCREEN_WIDTH-(3.5*spacing)+((i-7)*SCREEN_WIDTH/28)):y(-60+((i-7)*spacing*0.7))
			end

			if params.Sleep then
				self:sleep(0.103044*(i-7)*params.Sleep-0.103044):linear(0.1):rotationy(0)
			else
				if i == 13 then
					self:sleep(0.103044*(i-4)):linear(0.1):rotationy(0)
				elseif i == 14 then
					self:sleep(0.103044*(i-2)):linear(0.1):rotationy(0)
				else
					self:sleep(0.103044*(i-7)):linear(0.1):rotationy(0)
				end
			end

			self:accelerate(1.35-0.5):x(SCREEN_WIDTH+((i-7)*spacing))
		end,
		Def.Sprite{
			Name = 'SideAllay'..i,
			Texture = 'allay 8x7.png';
			Frames=Sprite.LinearFrames(51, 4),
			InitCommand = function(self) 
			  --allay10 = self; 
			  self:zoom(0.7):rotationy(180)
			  self:wag():effectmagnitude(-1,5,-1):animate(false):visible(true)
			end; 
			ActiveCommand=function(self)
				self:linear(0.2):zoom(0.8):addy(15):addrotationy(360)
				self:linear(0.3):zoom(0.7)
			end,
			PickUpItems2MessageCommand = function(self)
				self:addrotationy(180)
				self:decelerate(4):x(P1xpos+50):y(P1ypos/3)
				self:linear(0):addrotationy(180) 
				self:linear(3.25):addx(2.05*SCREEN_WIDTH/4):addy(1.5*SCREEN_HEIGHT/4) 
				self:linear(0):addrotationy(180) 
			end
		},
        Def.Sprite {
        Texture = 'dance 3x1.png';
        Name = "SideArrow1-"..i,
        InitCommand = function(self) 
           -- arrow = self
            self:visible(true):zoom(0.23):setstate(i == 13 and 0 or (i-7) % 2 == 1 and 0 or 2):animate(false):x(30):y(25)
            self:wag():effectmagnitude(1,10,1)
        end;
        SpaceInvaders2MessageCommand = function(self, params)
			if params then
				if params.Positions then
					-- colorN = string.sub(notes[currNote][2], 1, 1)
					local dir = string.sub(params.Positions, (i-7), (i-7))
					switch[dir](self)
				end
				if params.Type then
					local noteType= string.sub(params.Type, (i-7), (i-7))
					switch2[noteType](self)
				end
			end
        end
        },
		Def.Sprite {
			Texture = 'dance 3x1.png';
			Name = "SideArrow2-",
			InitCommand = function(self) 
				--arrow = self
				self:visible(false):zoom(0.23):setstate(i == 13 and 0 or (i-7) % 2 == 1 and 0 or 2):animate(false):x(-16):y(25)
				self:wag():effectmagnitude(1,10,1)
			end;
			SpaceInvaders2MessageCommand = function(self, params)
				if params then
					if params.Positions then
						-- colorN = string.sub(notes[currNote][2], 1, 1)
						local dir = string.sub(params.Positions, (i-7), (i-7))
						switch[dir](self)
					end
					if params.Type then
						local noteType= string.sub(params.Type, (i-7), (i-7))
						switch2[noteType](self)
					end
				end
			end
			}
    }
    arrows[i] = arrow
end
return af
